![[Pasted image 20250421195747.png]]
Applied at the end of outgoing mail.

## Importance of Outgoing Email Protection
- Outbound emails can contain sensitive information that needs protection.
- Scanning outgoing emails ensures compliance with security policies and prevents data leaks.

## DLP Feature Overview
##### Purpose
- Secures proprietary information and intellectual property.
- Enforces compliance with regulations by preventing unauthorized data transmission.
##### Functionality
- Scans outgoing emails for sensitive data using predefined DLP policies.
- Evaluates message content, headers, and attachments for disallowed patterns.

## DLP Policy Configuration
##### Policy Creation
- Define types of data that employees cannot email.
- Use DLP policies to scan outgoing messages for violations.
##### Content Evaluation
- Match text patterns like social security numbers or credit card details.
- Assess context to minimize false positives, such as requiring supporting information for credit card numbers.

## DLP Message Scanning Flow
##### Process
- Messages pass through the work queue and are scanned by DLP policies.
- Sensitive content triggers actions based on severity, such as quarantining or dropping messages.
##### Classifiers
- Use rules to detect violations, including words, phrases, regular expressions, and dictionaries.
- Assign risk factor scores to potential violations, influencing severity levels.
![[Pasted image 20250421200046.png]]

## Severity Ratings and Actions

##### Severity Levels
- Risk factor scores determine severity (low, critical, etc.).
- Severity influences actions like notification or quarantine.
![[Pasted image 20250421200119.png]]

##### Actions
- Primary actions: **Deliver**, **Drop**, **Quarantine**.
- Secondary actions: Encrypt, Alter subject, Add disclaimer, Notify sender.
![[Pasted image 20250421200142.png]]

## DLP Policies
![[Pasted image 20250421200238.png]]
##### Predefined Templates
- Regulatory compliance, acceptable use, privacy protection, intellectual property protection.
- Templates can be customized to fit organizational needs.
##### Custom Policies
- Create policies from scratch with custom classifiers.
- Define specific rules for detecting violations.

## Example Scenario
##### Department-Specific Requirements
- **IT Department**: Drop emails with network diagram attachments.
- **Sales Department**: Encrypt emails with credit card numbers.
- **HR Department**: Quarantine emails with social security numbers.
![[Pasted image 20250421200326.png]]

## Configuration and Management
##### Enabling DLP
- DLP must be enabled globally, with policies applied to outgoing mail.
- Use the DLP assessment wizard for streamlined setup.
##### Policy Quarantine
- Dedicated quarantine for messages violating DLP policies.
- Centralized management on Cisco Secure Email and Web Manager.

## Final Notes
- DLP is crucial for preventing data breaches and ensuring compliance.
- Effective configuration requires understanding organizational needs and customising policies accordingly.